<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="hero">
    <div class="hero-slideshow">
        <div class="slide active" style="background-image: url('images/front-view-blurry-lawyer-working.jpg');"></div>
        <div class="slide" style="background-image: url('images/law-justice-gavel-statue-books.jpg');"></div>
        <div class="slide" style="background-image: url('images/judge-holding-gavel-courtroom.jpg');"></div>
    </div>

    <div class="hero-overlay"></div>

    <div class="hero-content">
        <h2>Administration of Civil Justice</h2>
        <p>Exercising Appellate Jurisdiction over District Courts & Magistrate Courts across the Provinces.</p>
        <a href="daily_list.php" class="btn-gold">View Appeal Court List</a>
    </div>
</section>

<script>
    let currentSlide = 0;
    const slides = document.querySelectorAll('.slide');
    const totalSlides = slides.length;

    function nextSlide() {
        slides[currentSlide].classList.remove('active');
        currentSlide = (currentSlide + 1) % totalSlides;
        slides[currentSlide].classList.add('active');
    }
    setInterval(nextSlide, 5000);
</script><br><br>

<section class="services-grid reveal">
    <div class="card">
        <i class="fas fa-folder-open fa-3x" style="color:var(--primary-color)"></i>
        <h3>Appeal Status</h3>
        <p>Track the progress of Civil Appeals filed from District Courts.</p>
    </div>
    
    <div class="card">
        <i class="fas fa-calendar-alt fa-3x" style="color:var(--primary-color)"></i>
        <h3>Court Calendar</h3>
        <p>View the daily argument roll and mention list for all courtrooms.</p>
    </div>

    <div class="card">
        <i class="fas fa-file-signature fa-3x" style="color:var(--primary-color)"></i>
        <h3>Stay Orders</h3>
        <p>Procedures for interim relief and stay order applications.</p>
    </div>

    <div class="card">
        <i class="fas fa-gavel fa-3x" style="color:var(--primary-color)"></i>
        <h3>Judgments</h3>
        <p>Access the archive of recent Civil Appellate High Court judgments.</p>
    </div>
</section>

<div class="reveal" style="padding: 60px 8%; display:flex; gap:40px; flex-wrap:wrap;">
    <div style="flex: 1; min-width: 300px;">
        <h4 style="color:var(--gold-accent); text-transform:uppercase;">Welcome to</h4>
        <h2 style="color:var(--primary-color); font-size:2.5rem; margin-bottom:20px;">The Civil Appellate High Court</h2>
        <p style="margin-bottom:20px;">
            The Civil Appellate High Court was established to expedite the hearing of civil appeals from the District Courts, previously heard by the Court of Appeal. This decentralization ensures that justice in civil disputes—ranging from land matters to contracts—is accessible and efficient.
        </p>
        <p>
            We are committed to upholding the rights of citizens through a fair, impartial, and timely appellate process.
        </p>
        <br>
        <a href="about.php" class="btn-gold" style="background:var(--primary-color); color:white; transition: 0.3s; display:inline-block;">Read More</a>
    </div>

    <div style="flex: 1; min-width: 300px;">
        <img class="hover-scale" src="https://courtofappeal.lk/wp-content/uploads/2021/12/grey-marble-column-details-building-scaled.jpg" alt="Court Complex" style="width:100%; border-radius:10px; box-shadow:0 10px 30px rgba(0,0,0,0.2);">
    </div>
</div>

<section class="news-section reveal" style="padding: 80px 8%; background-color: var(--bg-light);">
    <div style="text-align: center; margin-bottom: 50px;">
        <p style="font-family: 'Playfair Display', serif; font-style: italic; color: var(--gold-accent); font-size: 1.2rem;">Latest Updates</p>
        <h2 style="color: var(--primary-color); font-size: 2.2rem;">Judicial Announcements</h2>
        <div style="width: 50px; height: 3px; background-color: var(--gold-accent); margin: 15px auto;"></div>
    </div>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 25px;">
        
        <div class="news-card" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <img src="images/news/1.jpg" alt="Ceremonial Sitting" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
                <span style="font-size: 0.75rem; color: var(--gold-accent); font-weight: bold;">NEWS</span>
                <h4 style="margin: 10px 0; color: var(--primary-color);">Practice Direction: Land Appeal Briefs</h4>
                <p style="font-size: 0.9rem; color: #666;">New formatting requirements for briefs filed in Land Acquisition appeals effective next month.</p>
            </div>
        </div>

        <div class="news-card" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <img src="images/news/3.jpg" alt="Commercial Court" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
                <span style="font-size: 0.75rem; color: var(--gold-accent); font-weight: bold;">NOTICES</span>
                <h4 style="margin: 10px 0; color: var(--primary-color);">Written Submissions Deadline</h4>
                <p style="font-size: 0.9rem; color: #666;">All parties are reminded to file written submissions 2 weeks prior to argument dates.</p>
            </div>
        </div>

        <div class="news-card" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <img src="images/news/4.jpg" alt="Judgment" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
                <span style="font-size: 0.75rem; color: var(--gold-accent); font-weight: bold;">JUDGMENTS</span>
                <h4 style="margin: 10px 0; color: var(--primary-color);">Partition Law Ruling</h4>
                <p style="font-size: 0.9rem; color: #666;">A significant judgment regarding corpus definition in Partition Actions was delivered yesterday.</p>
            </div>
        </div>

    </div>
</section>

<script>
    window.addEventListener('scroll', reveal);
    function reveal(){
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150; 
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    }
    reveal();
</script>

<?php include 'footer.php'; ?>